//EX 11 Program Title:To find operating points of BJT for Voltage Divider bias.//////
//environment: Scilab 5.5.2
//Tested on OS: Windows 7 Professional, 64 bit
//Book: Electronics Devices and Circuit Theory  by Robert Boylestead and Nashelsky
/////////////////////////////////////////
clc;
clear all;
close;
//////////////////////////////////////////////////////////////////
disp('For BJT Voltage Divider Bias:' );
R1_1=input('Enter the value of Base resisance 1 in Kilo Ohms         R1:');//Note:Press enter/
R2_1=input('Enter the value of Base resistance 2 in Kilo Ohms        R2:');//Note:Press enter/
RC_1=input('Enter the value of Collector resistance  in Kilo Ohms    RC:');//Note:Press enter///collector resistance value should bel less than R1 and R2
RE_1=input('Enter the value of Emitter resistance  in Kilo Ohms      RE:');//Note:Press enter///Emitter Resistance value should be less than collector resistanc
Betadc=input('Enter the value of Beta                                Betadc:');//Note:Press enter/
VCC=input('Enter the Supply Voltage in Volts                         VCC:');//Note:Press enter/
R1=R1_1*1e3   // Kilo ohms  Base resistance 1 
R2=R2_1*1e3    // Kilo ohms   base resistance 2
RC=RC_1*1e3    // Kilo ohms   Collector resistance 
RE=RE_1*1e3   // kilo ohm   Emitter Resistance
//C1  uf  input capaciance open circuited in DC analysis
//C2  uf  output capaciance open circuited in DC analysis
VBE=0.7  //Volts Base to Emitter voltage
mprintf('\n. \********************************************\');
disp('Given data for BJT Voltage Divider Bias is:' );
mprintf(' Base resistance 1        R1:%.2f Ohms',R1);
mprintf('\n Base resistance 2        R2:%2d Ohms',R2);
mprintf('\n Collector resistance     RC:%2d Ohms',RC);
mprintf('\n Emitter resistance       RE:%2d Ohms',RE);
mprintf('\n CE DC Current Gain       Betadc:%2d V',Betadc);
mprintf('\n Collector Supply Voltage VCC:%2d V',VCC);
mprintf('\n Base to Emitter Voltage  VBE:%.1f V',VBE);
//////////////////Calculation of IB current to find out ICQ///////////////////////////
mprintf('\n. \********************************************\');
Rth=(R1*R2)/(R1+R2);  // Thevenin Equivalent Resistance
Vth=(R2*VCC)/(R1+R2);   /// Open Circuit Thevenin Voltage
IB=(Vth-VBE)/(Rth+(Betadc+1)*RE);// Base Current
IB_=IB*1e6  // ampere for display
mprintf('\n Thevenin Equivalent Resistance    Rth:%2d Ohms',Rth);
mprintf('\n Open Circuit Thevenin Voltage     Vth:%.2f V',Vth);
mprintf('\n Base Current                      IB:%.2f uA',IB_);
////////////////////Calculatin of ICQ and VCEQ////////////////////////
mprintf('\n. \********************************************\');
ICQ=Betadc*IB;  // Collector cueernt
ICQ_=ICQ*1e3    // ampere for display
VCEQ=VCC-ICQ*(RC+RE);  // collector to emitter voltage
mprintf('\n Operating Point Collector To Emitter Voltage   VCEQ:%.2f V',VCEQ);//Display
mprintf('\n Operating Point Collector Current              ICQ:%.4f mA',ICQ_);

///output////
  
 
// For BJT Voltage Divider Bias:   
//Enter the value of Base resisance 1 in Kilo Ohms         R1:82
//Enter the value of Base resistance 2 in Kilo Ohms        R2:22
//Enter the value of Collector resistance  in Kilo Ohms    RC:5.6
//Enter the value of Emitter resistance  in Kilo Ohms      RE:1.2
//Enter the value of Beta                                Betadc:50
//Enter the Supply Voltage in Volts                         VCC:18

//. ******************************************** 
// Given data for BJT Voltage Divider Bias is:   
// Base resistance 1        R1:82000.00 Ohms
// Base resistance 2        R2:22000 Ohms
// Collector resistance     RC:5600 Ohms
// Emitter resistance       RE:1200 Ohms
// CE DC Current Gain       Betadc:50 V
// Collector Supply Voltage VCC:18 V
// Base to Emitter Voltage  VBE:0.7 V
//. ********************************************
// Thevenin Equivalent Resistance    Rth:17346 Ohms
// Open Circuit Thevenin Voltage     Vth:3.81 V
// Base Current                      IB:39.57 uA
//. ********************************************
// Operating Point Collector To Emitter Voltage   VCEQ:4.55 V
// Operating Point Collector Current              ICQ:1.9783 mA 
